package gov.va.med.mhv.sm.web.actions;

import gov.va.med.mhv.foundation.service.response.CollectionServiceResponse;
import gov.va.med.mhv.foundation.service.response.ServiceResponse;
import gov.va.med.mhv.foundation.service.response.messages.Message;
import gov.va.med.mhv.foundation.service.response.messages.MessageUtils;
import gov.va.med.mhv.sm.dao.PatientTriageMapDao;
import gov.va.med.mhv.sm.dao.UserDao;
import gov.va.med.mhv.sm.util.DateUtils;
import gov.va.med.mhv.sm.enumeration.RelationTypeEnum;
import gov.va.med.mhv.sm.model.Clinician;
import gov.va.med.mhv.sm.model.Facility;
import gov.va.med.mhv.sm.model.MHVPatient;
import gov.va.med.mhv.sm.model.Patient;
import gov.va.med.mhv.sm.model.TriageGroup;
import gov.va.med.mhv.sm.model.TriageRelation;
import gov.va.med.mhv.sm.model.User;
import gov.va.med.mhv.sm.service.AdminService;
import gov.va.med.mhv.sm.service.FacilityService;
import gov.va.med.mhv.sm.service.PatientBlockedService;
import gov.va.med.mhv.sm.service.RelationshipManagementService;
import gov.va.med.mhv.sm.service.TriageGroupService;
import gov.va.med.mhv.sm.service.UserManagementService;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.Clinic;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.Provider;
import gov.va.med.mhv.sm.wsclient.adminqueriessvc.Team;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Locale;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts2.ServletActionContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

import com.opensymphony.xwork2.ModelDriven;
import com.opensymphony.xwork2.Preparable;

public abstract class AbstractTriageGroupAction extends BaseSMAdminAction implements Preparable, ModelDriven {

	private static final long serialVersionUID = 7062326421080050064L;
	private static final Log log = LogFactory.getLog(AbstractTriageGroupAction.class);
	protected static final String CREATE_FUNCTION = "CREATE";
	protected static final String EDIT_FUNCTION = "EDIT";
	protected static final String TRIAGE_GROUP_SESSION_KEY = "triageGroup";
	private UserManagementService userManagementService = null;
	private TriageGroupService triageGroupService = null;
	private PatientBlockedService patientBlockedService=null;
	private RelationshipManagementService relationshipManagementService = null;
	private UserDao userDao = null;
	private PatientTriageMapDao patientTriageMapDao = null;
	protected static final String VISN_ATTR_NAME = "VISN_ATTR_NAME";
	protected static final String FACILITY_ATTR_NAME = "FACILITY_ATTR_NAME";
	protected static final String STEP1 = "STEP1";
	protected static final String STEP4 = "STEP4";
	private static final Message NO_CLINIC_NAME_ENTERED = MessageUtils.createErrorMessage("triagegroup.no.clinic.name.entered", null, null);
	private static final Message NO_OE_RR_TEAM_NAME_ENTERED = MessageUtils.createErrorMessage("triagegroup.no.oe.rr.team.name.entered", null, null);
	private static final Message NO_PCMM_LASTNAME_ENTERED = MessageUtils.createErrorMessage("triagegroup.no.pcmm.lastname.entered", null, null);
	private Set existingClinicians = new HashSet();
	
	

	protected abstract String getFunction();

	public TriageGroup getTriageGroup() {
		TriageGroup result = null;
		if ( needReload() ) {
			String name = (String)getSessionAttribute("TRIAGE_GROUP_NAME");
			name = name.trim();

			if ( name != null) {

				result = load(name);
			} else {

				result = new TriageGroup();
			}
			setNeedReload(false, null);
			setSessionAttribute(TRIAGE_GROUP_SESSION_KEY, result);
		} else {
			result = (TriageGroup)getSessionAttribute(TRIAGE_GROUP_SESSION_KEY);
		}
		if ( result == null ){
			result = new TriageGroup();
			setSessionAttribute(TRIAGE_GROUP_SESSION_KEY, result);
		}
		return result;
	}

	protected TriageGroup load(String name) {
		ServiceResponse<TriageGroup> tgResp = getTriageGroupService().findActiveTriageGroupByName(name);
		if ( tgResp.getMessages().hasErrorMessages() ) {
			for(Object o : tgResp.getMessages().getErrorMessages() ) {
				Message m = (Message)o;
				for(Object insert : m.getInserts() ) {
					this.addActionError(insert.toString());
				}
			}
			return null;
		}
		TriageGroup result = tgResp.getPayload();
		// force initialization
		for(TriageRelation tr : result.getRelations() ){
			tr.getName();
		}
		for(Clinician c : result.getClinicians()) {
			c.getName();
		}
		return result;
	}

	private boolean needReload() {
		Boolean need = (Boolean)getSessionAttribute("TG_RELOAD");
		if ( need == null || ! need.booleanValue() ) return false;
		Boolean nextReq = (Boolean)getServletRequest().getAttribute("TG_RELOAD_NEXT_REQ");
		return nextReq == null || ! nextReq.booleanValue();
	}

	private void setNeedReload(boolean val, String name) {
		setSessionAttribute("TG_RELOAD", Boolean.valueOf(val));
		if ( val ) {
			setSessionAttribute("TRIAGE_GROUP_NAME", name);
			getServletRequest().setAttribute("TG_RELOAD_NEXT_REQ", Boolean.TRUE);
		}
	}

	public void setTriageGroup(TriageGroup group) {
		setSessionAttribute(TRIAGE_GROUP_SESSION_KEY, group);
	}

	public void clearTriageGroup() {
		removeSessionAttribute(TRIAGE_GROUP_SESSION_KEY);
		removeSessionAttribute("searchResult");
		removeSessionAttribute("MHVSearchResult");
		removeSessionAttribute("selectedTriageRelationship");

		//CR5625 - retain previous visn & facility selection
		//removeSessionAttribute(VISN_ATTR_NAME);
		//removeSessionAttribute(FACILITY_ATTR_NAME);
	}

	public void prepare() throws Exception {
		super.prepare();
		WebApplicationContext ctx = WebApplicationContextUtils
			.getWebApplicationContext(ServletActionContext.getServletContext());
		setAdminService((AdminService)ctx.getBean("adminService"));
		setFacilityService((FacilityService)ctx.getBean("facilityService"));
		setUserManagementService((UserManagementService)ctx.getBean("userManagementService"));
		setUserDao((UserDao)ctx.getBean("userDao"));
		setRelationshipManagementService((RelationshipManagementService)ctx.getBean("relationshipManagementService"));
		setTriageGroupService((TriageGroupService)ctx.getBean("triageGroupService"));
		setPatientBlockedService((PatientBlockedService)ctx.getBean("patientBlockedService"));
		
	}

	public Collection<Facility> getAdministeredFacilitiesInVisn() {
		if ( this.getVisnId() == null ) {
			return new TreeSet<Facility>();
		} else {
			return getAdministeredFacilitiesInVisn(getVisn());
		}
	}

	public String chooseVisn() {
		if ( cancelButtonPressed() ) {
			return "CANCEL";
		}
		Long newVisnId = getParameterAsLong("visnId");
		Facility oldVisn = (Facility)getSessionAttribute(VISN_ATTR_NAME);
		if ( oldVisn != null && ! oldVisn.getId().equals(newVisnId) ) {
			clearMembersAndRelations();
		}
		setVisnId(newVisnId);
		return SUCCESS;
	}

	public boolean getShowAdministeredVisnList() {
		boolean result = getAdministeredVisns().size() > 1;
		return result;
	}

	public boolean getShowAdministeredFacilityList() {
		boolean result = this.getAdministeredFacilitiesInVisn().size() > 1
			|| (getCurrentUser().isNational());
		return result;
	}

	public Long getVisnId() {
		Facility visn = getVisn();
		if ( visn != null ) {
			return visn.getId();
		} else {
			return null;
		}
	}

	public void setVisnId(Long visnId) {
		setSessionAttribute(VISN_ATTR_NAME, getFacilityService().getFacility(visnId).getPayload());
	}

	public Facility getVisn() {
		Facility visn = (Facility)getSessionAttribute(VISN_ATTR_NAME);
		if ( visn == null && ! getShowAdministeredVisnList() ) {
			visn = getAdministeredVisns().iterator().next();
			this.setSessionAttribute(VISN_ATTR_NAME, visn);
		}
		return visn;
	}

	public Object getModel() {
		return getTriageGroup();
	}

	public Long getFacilityId() {
		Facility f = getFacility();
		if ( f != null ) {
			return f.getId();
		} else {
			return null;
		}
	}

	public void setFacilityId(Long facilityId) {
		setFacility(getFacilityService().getFacility(facilityId).getPayload());
	}

	public void setFacility(Facility facility) {
		this.getTriageGroup().setVistaDiv(facility.getStationNumber());
		this.setSessionAttribute(FACILITY_ATTR_NAME, facility);
	}

	public Facility getFacility() {
		Facility f = (Facility)getSessionAttribute(FACILITY_ATTR_NAME);
		if ( f == null && ! this.getShowAdministeredFacilityList() ) {
			f = this.getAdministeredFacilitiesInVisn().iterator().next();
			this.setSessionAttribute(FACILITY_ATTR_NAME, f);
		}
		return f;
	}

	public Collection<Clinician> getAvailableClinicians() {
		Collection<Clinician> result = new TreeSet<Clinician>(User.USER_BY_NAME_SORTER);
		result.addAll(getUserManagementService()
			.getCliniciansForStation(getFacility().getStationNumber()).getCollection());
		Collection<Clinician> assigned = getTriageGroup().getClinicians();
		if ( assigned != null ) {
			result.removeAll(assigned);
		}
		return result;
	}

	public String updateTriageClinicians() {
		if ( ! StringUtils.isBlank(this.getParameter("add")) ) {
			addClinicians(this.getParameterValueList("cliniciansToAdd"));
		} else if ( ! StringUtils.isBlank(this.getParameter("remove")) ) {
			setExistingClinicians(this.getParameterValueList("cliniciansToRemove"));
			removeClinicians(this.getParameterValueList("cliniciansToRemove"));
		}
		return SUCCESS;
	}

	private void setExistingClinicians(Collection<String> idString){

		if(getSession().getAttribute("REMOVED_CLINICIAN_LIST")!=null){
			Set prevClinicianSet = (Set)getSession().getAttribute("REMOVED_CLINICIAN_LIST");
			Iterator iter1 = prevClinicianSet.iterator();
			while(iter1.hasNext()){
				existingClinicians.add(Long.parseLong(iter1.next().toString()));
			}
		}
		for(String idStr : idString)
		{
			    existingClinicians.add(Long.parseLong(idStr.toString()));
		}
		getSession().setAttribute("REMOVED_CLINICIAN_LIST",existingClinicians);
	}


	private void removeClinicians(Collection<String> idStrings) {
	    Collection<Clinician> toRemove = new HashSet<Clinician>();
		for(Clinician c : getTriageGroup().getClinicians() ) {
			if ( idStrings.contains(c.getId().toString())) {
				toRemove.add(c);

			}
		}
		getTriageGroup().getClinicians().removeAll(toRemove);
	}

	private void addClinicians(Collection<String> idStrings) {
		Map<Long, Clinician> all = getAllCliniciansMap();
		for(String idStr : idStrings) {
			Long id = Long.parseLong(idStr);
			getTriageGroup().getClinicians().add(all.get(id));
		}
		java.util.Collections.sort(getTriageGroup().getClinicians(), User.USER_BY_NAME_SORTER);

	}
	public String chooseTriageFacility() {
		if ( cancelButtonPressed() ) {
			return "CANCEL";
		}
		Long newId = getParameterAsLong("newFacilityId");
		Long oldId = getFacilityId();
		if ( oldId != null && ! oldId.equals(newId) ) {
			clearMembersAndRelations();
		}
		setFacilityId(newId);
		return SUCCESS;
	}

	public String addTriageRelations() {
		removeSessionAttribute("searchResult");
		removeSessionAttribute("MHVSearchResult");
		removeSessionAttribute("selectedTriageRelationship");
		setSessionAttribute("saveType","");
		if ( cancelButtonPressed() ) {
			return "CANCEL";
		} else if ( ! StringUtils.isBlank(getParameter("addProviderRelation"))) {
			return "TRIAGE_PROVIDER_RELATION";
		} else if ( ! StringUtils.isBlank(getParameter("addClinicRelation"))) {
			return "TRIAGE_CLINIC_RELATION";
		} else if ( ! StringUtils.isBlank(getParameter("addTeamRelation"))) {
			return "TRIAGE_TEAM_RELATION";
		} else if(  ! StringUtils.isBlank(getParameter("addPatientRelation"))){
			return "TRIAGE_PATIENT_RELATION";
		} else if ( ! StringUtils.isBlank(getParameter("save")))
		{
			setSessionAttribute("saveType","savePatientTriageMap");	//This session Attribute will set when the user click the SaveGroup in RelationShip page.
			if ( saveTriageGroup() ) {
				return SUCCESS;
			} else {
				return INPUT;
			}
		}
		return INPUT;
	}



	public String searchProviders() {
		if ( cancelButtonPressed() ) {
			clearPendingRelations();
			return "CANCEL";
		}
		Map<String, String> searchResultMap = new HashMap<String, String>();
		String firstName = getParameter("searchFirstName");
		String lastName = getParameter("searchLastName");
		if (lastName.trim().length() == 0) {
			handleError(NO_PCMM_LASTNAME_ENTERED);
		} else {
			CollectionServiceResponse<Provider> response = this.getAdminService().searchPcmmProviders(getFacility().getStationNumber(), lastName, firstName);
			Collection<Provider> searchResult = response.getCollection();

			if ( (searchResult == null || searchResult.isEmpty()) && !response.getMessages().hasErrorMessages() ) {
				addActionError("No providers found matching query string: " + firstName + " " + lastName);
			} else {
				handleErrorMessages(response.getMessages());
				for(Provider p : searchResult) {
					searchResultMap.put(p.getIEN().toPlainString(), p.getLastName() + ", " + p.getFirstName());
				}
			}
		}
		Map sortedSearchResultMap = sortedResultMap(searchResultMap); // Implemented for CR# 4609.
		setSessionAttribute("searchResult",sortedSearchResultMap);

		return SUCCESS;
	}

	public String searchClinics() {
		if ( cancelButtonPressed() ) {
			clearPendingRelations();
			return "CANCEL";
		}
		String query = getParameter("searchClinicName");
		Map<String, String> searchResultMap = new HashMap<String, String>();

		if (query.trim().length() == 0) {
			 handleError(NO_CLINIC_NAME_ENTERED);
		} else {
			CollectionServiceResponse<Clinic> response = this.getAdminService().searchClinics(getFacility().getStationNumber(), query);
			Collection<Clinic> searchResult = response.getCollection();
			if ( (searchResult == null || searchResult.isEmpty()) && !response.getMessages().hasErrorMessages() ) {
				addActionError("No clinics found matching query string: " + query);
			} else {
				handleErrorMessages(response.getMessages());
				for(Clinic c : searchResult) {
					searchResultMap.put(c.getIEN(), c.getName());
				}
			}
		}
		Map sortedSearchResultMap = sortedResultMap(searchResultMap); // Implemented for CR# 4609.
        setSessionAttribute("searchResult",sortedSearchResultMap);
		return SUCCESS;
	}

	// searchPatients method has been implmented for the CR#4826. method will search the data from ServiceImpl based on the search criteria.
	public String searchPatients() {
		if ( cancelButtonPressed() ) {
			clearPendingRelations();
			return "CANCEL";
		}

		String searchFirstName = getParameter("searchFirstName");
		String searchLastName = getParameter("searchLastName");
		String searchLastNameNSSN = getParameter("searchLastNameNSSN");

		//holds formatted users keys
		Map<String, String> searchResultMap = new HashMap<String, String>();
		//verified to filter to unique set of matches first from SMS and then from MHV
		Set<String> matchedSMSPatients = new HashSet<String>();
		//holds formatted users keys
		Map<String, String> MHVSearchResultMap = new HashMap<String, String>();
		if(searchLastName.trim().length() == 0 && searchLastNameNSSN.trim().length() == 0 )
		{
			addActionError("Last Name or First Letter of Last Name + Last 4 of SSN are required.");
		}
		else
		{
			CollectionServiceResponse<Patient> response =
				userManagementService.searchForPatients(searchFirstName, searchLastName, searchLastNameNSSN, getFacility().getStationNumber());

			Collection<Patient> searchResult = response.getCollection();
			for(Patient p : searchResult) {
				searchResultMap.put(p.getId().toString(),patientNameDecorator(p));
				matchedSMSPatients.add(p.getUsername());
			}

			CollectionServiceResponse<MHVPatient> MHVResponse =
				userManagementService.searchForMHVPatients(searchFirstName, searchLastName, searchLastNameNSSN, getFacility().getStationNumber());
			Collection<MHVPatient> MHVSearchResult = MHVResponse.getCollection();
			//check to see if this user is found in SM, if not add this user with demracation of MHV map.
			for(MHVPatient p : MHVSearchResult) {
				if(!matchedSMSPatients.contains(p.getUserName())){
					searchResultMap.put(p.getId().toString(),patientNameDecorator(p));
					MHVSearchResultMap.put(p.getId().toString(),patientNameDecorator(p));
				}
			}
		}
		Map sortedSearchResultMap = sortedResultMap(searchResultMap); // Implemented for CR# 4609.
        setSessionAttribute("searchResult",sortedSearchResultMap);
        setSessionAttribute("MHVSearchResult",MHVSearchResultMap);
		return SUCCESS;
	}

    /*
	 * Decorates the patient Name with NSSN to display while creating manual relationships in Triage Group(CQ# 5352).
	 */
    public String patientNameDecorator(Patient p){
    	 String patientMiddleName =  p.getMiddleName()!=null ? p.getMiddleName():"";
    	 String patientNssn = p.getNssn() !=null ? p.getNssn().toUpperCase() : "";
    	 String patientDob = p.getDob()!=null?DateUtils.getEnglishDate(p.getDob()):"";
    	 String patientNameWithnSSN = p.getLastName().toUpperCase()+", "+p.getFirstName().toUpperCase()+" "+patientMiddleName+"(SSN:"+patientNssn+")(DOB: "+patientDob+")";
    	 return patientNameWithnSSN;
    }

    /*
	 * Decorates the patient Name with NSSN to display while creating manual relationships in Triage Group(CQ# 5352).
	 */
    public String patientNameDecorator(MHVPatient p){
    	 String patientMiddleName =  p.getMiddleName()!=null ? p.getMiddleName():"";
    	 String patientNssn = p.getNssn() !=null ? p.getNssn().toUpperCase() : "";
    	 String patientLastName = p.getLastName() !=null ? p.getLastName().toUpperCase() : "Null";
    	 String patientFirstName = p.getFirstName() !=null ? p.getFirstName().toUpperCase() : "Null";
    	 String patientDob = p.getDob()!=null?DateUtils.getEnglishDate(p.getDob()):"";
         String patientNameWithnSSN = patientLastName+", "+patientFirstName+" "+patientMiddleName+"(SSN:"+patientNssn+")(DOB: "+patientDob+")";
    	 return patientNameWithnSSN;
    }

	public String searchTeams() {
		if ( cancelButtonPressed() ) {
			clearPendingRelations();
			return "CANCEL";
		}
		String query = getParameter("searchTeamName");
		Map<String, String> searchResultMap = new HashMap<String, String>();

		if (query.trim().length() == 0) {
			handleError(NO_OE_RR_TEAM_NAME_ENTERED);
		} else {
			CollectionServiceResponse<Team> response = this.getAdminService().searchTeams(getFacility().getStationNumber(), query);
			Collection<Team> searchResult = response.getCollection();

			if ( (searchResult == null || searchResult.isEmpty()) && !response.getMessages().hasErrorMessages() ) {
				addActionError("No teams found matching query string: " + query);
			} else {
				handleErrorMessages(response.getMessages());
				for(Team t : searchResult) {
					log.info("Team IEN....."+t.getIEN());
					log.info("Team name....."+t.getName());
					searchResultMap.put(t.getIEN(), t.getName().toUpperCase());
				}
			}
		}
		TreeMap sortedSearchResultMap = sortedResultMap(searchResultMap); // Implemented for CR# 4609.
		setSessionAttribute("searchResult",sortedSearchResultMap);
		return SUCCESS;
	}

	@SuppressWarnings("unchecked")
	public String updateTriageRelations() {
		String result = null;
		if(cancelButtonPressed())
		{
			clearPendingRelations();
			result = "CANCEL";
		}else if(!StringUtils.isBlank(getParameter("save"))) 
		{
			removeSessionAttribute("searchResult");
			removeSessionAttribute("selectedTriageRelationship");
			//saveRelationships()
			if(saveRelationships()){
			//if ( saveTriageGroup() ) {
				result = "SAVE";
			} else {
				result = getParameter("relationType");
			}
		} else {
			// Add or remove relations
			String typeStr = getParameter("relationType");
			RelationTypeEnum type = RelationTypeEnum.valueOf(typeStr);
			if ( ! StringUtils.isBlank(this.getParameter("add")) ) {
				Map<String, String> searchResultMap = (Map)getSessionAttribute("searchResult");
				Map<String, String> selectedTriageRelationship = (Map)getSessionAttribute("selectedTriageRelationship");
				for(String ien : getParameterValueList("relationsToAdd")) {
					String smsUserID = null;
					//if this user is from mhv, add the user to SM and get the user id
					Map<String, String> MHVSearchResultMap = (Map)getSessionAttribute("MHVSearchResult");
					if(MHVSearchResultMap != null && MHVSearchResultMap.containsKey(ien)){
						MHVPatient mhvPatient = getUserDao().findMHVPatientById(new Long(ien),getFacility().getStationNumber());

						ServiceResponse<Patient> responsePatient = userManagementService.createOrUpdatePatientFrom(mhvPatient);
						Patient patient = responsePatient.getPayload();
						if(patient != null){
							smsUserID = patient.getId().toString();
						}
						//this user now is in SM. so it should get from sm.
						MHVSearchResultMap.remove(ien);
					}else{
						smsUserID = ien;
					}

					TriageRelation tr = new TriageRelation();
					tr.setVistaIen(smsUserID);
					tr.setRelationType(type);
					tr.setName(searchResultMap.get(ien));
					tr.setStationNumber(getFacility().getStationNumber());
					manageTriageRelationPendingAdd(tr);
					selectedTriageRelationship.put(ien,tr.getName());

				}
			} else if ( ! StringUtils.isBlank(getParameter("remove")) ) {
				Map<String, String> selectedTriageRelationship = (Map)getSessionAttribute("selectedTriageRelationship");
				for(String ien : getParameterValueList("relationsToRemove")) {
					TriageRelation tr = new TriageRelation();
					tr.setVistaIen(ien);
					tr.setRelationType(type);
					tr.setStationNumber(getFacility().getStationNumber());
					manageTriageRelationPendingDelete(tr);
					selectedTriageRelationship.remove(tr.getVistaIen());
				}
			}
			result = typeStr;
		}
		return result;
	}

	
	private boolean saveRelationships(){
		
	
		TriageGroup tg = getTriageGroup();
		
		if(log.isInfoEnabled()){
			log.info("101->Save TriageGroup Relations->"+tg.getId()+"^"+tg.getRelations());
		}
		
		if (tg.getId()!=null){
			tg = (TriageGroup)this.reattach(tg);
			if(StringUtils.isBlank(this.getParameter("delete")))
			{
				reattach(tg.getClinicians());
			}
			reattach(tg.getRelations());
		}
		if(!validTriageGroup()){
			return false;
		}
		// Remove pending deletions
		for(TriageRelation tr : getRelationsPendingDelete()) {
			for(TriageRelation existing : getTriageGroup().getRelations()){
				if(matches(tr, existing)){
					existing.setActive(false);
					existing.setModifiedDate(Calendar.getInstance().getTime());
				}
			}
		}
		// Add pending adds
		for(TriageRelation tr : getRelationsPendingAdd()) {
			boolean added = false;
			for(TriageRelation existing : getTriageGroup().getRelations()) {
				if(matches(tr, existing)){
					existing.setActive(true);
					existing.setName(tr.getName());
					existing.setModifiedDate(Calendar.getInstance().getTime());
					added = true;
					break;
				}
			}
			if(!added){
				tr.setActive(true);
				tg.addRelation(tr);
			}

		}

		clearPendingRelations();

		ServiceResponse<TriageGroup> response  = getAdminService().saveTriageGroup(tg);
		if(response.getMessages().hasErrorMessages())
		{
			if(log.isInfoEnabled()){
				log.info("103A->Save Relationships with Response Error->"+tg.getId());
			}
			return false;
		}else{
			TriageGroup updatedTriageGroup = response.getPayload();
			if(StringUtils.isBlank(this.getParameter("delete")))
			{
				setTriageGroup(updatedTriageGroup);
				setNeedReload(true, updatedTriageGroup.getName());
			}
			
			if(updatedTriageGroup.getId()!=null){
				CollectionServiceResponse<TriageRelation> triageRelationResponse = triageGroupService.getTriageRelationsForTriageGroup(updatedTriageGroup.getId());
				Collection<TriageRelation> triageRelations = triageRelationResponse.getCollection();
				for(TriageRelation triageRelation:triageRelations){
					if(triageRelation.getRelationType().equals(RelationTypeEnum.PATIENT))
					{
						Patient patient = getUserDao().findPatientById(new Long(triageRelation.getVistaIen()));
						getRelationshipManagementService().updatePatientTriageMap(patient,triageRelation);
						if(log.isInfoEnabled()){
							log.info("105--->Updated--->"+updatedTriageGroup.getId()+"^"+triageRelation.getVistaIen()+"^"+triageRelation.getName());	
						}
					}
				}	
			 }
			 return true;
		}
	}
	
	protected boolean validTriageGroup(){
		boolean result = true;
		if(StringUtils.isBlank(this.getParameter("delete"))){
			if ( this.getTriageGroup().getClinicians().isEmpty() ) {
				addActionError("You must choose at least one clinician or staff member.");
				result = false;
			}
		}
		return result;
	}


	@SuppressWarnings("unchecked")
	private void saveTriageGroupError(String err) {
		List<String> errors = (List)getServletRequest().getAttribute("MEMBER_DELETE_ERROR");

		if ( errors == null ) {
			errors = new ArrayList<String>();
			getServletRequest().setAttribute("MEMBER_DELETE_ERROR", errors);
		}
		errors.add(err);
	}

	public String reAssignAllMessages(){

		if (!StringUtils.isBlank(getParameter("Cancel"))) {
			return STEP4;
		}
		List msgList = (List) getSession().getAttribute("messagesList");

		log.info("msgList inside reassignAll*******"+msgList.size());
		long reAssignMemberId = Long.parseLong(getRequest().getParameter("selectedReAssignMember"));
		getTriageGroupService().reassignAllMessagesToMember(msgList, reAssignMemberId);
		return STEP1;
	}

	@SuppressWarnings("unchecked")
	public String reAssignMessageAndSaveGroup(){

		if (!StringUtils.isBlank(getParameter("Cancel"))) {
			return STEP4;
		}

		TriageGroup tg = getTriageGroup();
		long reAssignMemberId = Long.parseLong(getRequest().getParameter("selectedReAssignMember"));
		List msgList = (List)getSession().getAttribute("messageList");

		log.info("ReAssigned user..."+reAssignMemberId);
		log.info(tg.getClinicians());

		// ReAssign the Messages to the selected member from the drop down and create the addressee for the selected member.
		getTriageGroupService().reassignMessagesToMember(msgList, reAssignMemberId);

		// TO DO: Persist the triage group with the recent member values.
		if ( tg.getId() != null ) {
			tg = (TriageGroup)this.reattach(tg);
			reattach(tg.getRelations());
		}

		// Remove pending deletions
		for(TriageRelation tr : getRelationsPendingDelete()) {
			for(TriageRelation existing : getTriageGroup().getRelations()) {
				if (matches(tr, existing) ) {
					existing.setActive(false);
				}
			}
		}
		// Add pending adds
		for(TriageRelation tr : getRelationsPendingAdd()) {
			boolean added = false;
			for(TriageRelation existing : getTriageGroup().getRelations()) {
				if (matches(tr, existing) ) {
					existing.setActive(true);
					existing.setName(tr.getName());
					added = true;
					break;
				}
			}
			if ( ! added ) {
				tr.setActive(true);
				tg.addRelation(tr);
			}

		}
		clearPendingRelations();

		ServiceResponse<TriageGroup> response  = getAdminService().saveTriageGroup(tg);
			List relationList = tg.getRelations();
			for(int i=0;i<relationList.size();i++){
				TriageRelation triageRelation = (TriageRelation)relationList.get(i);
				if(triageRelation.getRelationType().equals(RelationTypeEnum.PATIENT))
				{
					Patient patient = getUserDao().findPatientById(new Long(triageRelation.getVistaIen()));
					getRelationshipManagementService().updatePatientTriageMap(patient,triageRelation);
				}
			}
			if(response.getMessages().hasErrorMessages() )
			{
				addActionError("Error saving triage group");
				return STEP4;
			}else
			{
				TriageGroup saved = response.getPayload();
				if(StringUtils.isBlank(this.getParameter("delete")))
				{
					setTriageGroup(saved);
					setNeedReload(true, saved.getName());
				}
				return STEP1;
			}
	}


	protected boolean saveTriageGroup() {

		TriageGroup tg = getTriageGroup();
		
		if(log.isInfoEnabled()){
			log.info("106--->Before Save Triage Group--->"+tg);
		}
		if(null != getSessionAttribute("saveType") && getSessionAttribute("saveType").equals("savePatientTriageMap")){
		List userIdsList = new ArrayList();
		// removedClinicianSet contains the removed member from the right hand side drop down.
		Set removedClinicianSet = (Set)getSession().getAttribute("REMOVED_CLINICIAN_LIST");
		if(removedClinicianSet !=null){
			for(Clinician clinician : tg.getClinicians()) {
				if(removedClinicianSet.contains(clinician.getId())){
					removedClinicianSet.remove(clinician.getId());
				}
			}
			userIdsList.addAll(removedClinicianSet);
		}
		if(userIdsList.size()>0){
			// Get the Collection of Assigned Message for the removed members from the group.
			CollectionServiceResponse<gov.va.med.mhv.sm.model.Message> results = getTriageGroupService().getAssignedMsgsForTriageGroup(tg,userIdsList);
			List messagesList = (List)results.getCollection();
			getSession().setAttribute("messageList",messagesList);
			if(messagesList.size() >0){
				StringBuilder message = new StringBuilder();
				message.append("This triage group member cannot be deleted because the member has ")
				.append("<strong>"+messagesList.size()+"</strong>")
				.append(messagesList.size() > 1 ? " messages" : " message")
				.append(" that have not been completed.")
				.append(" Select another triage group member to reassign the ")
				.append("<strong>"+messagesList.size()+"</strong>")
				.append(messagesList.size() > 1 ? " messages" : " message")
				.append(" that need to be completed");
				getServletRequest().setAttribute("REASSIGNCLINICIANS", tg.getClinicians());
				saveTriageGroupError(message.toString());
				return false;
			}
		  }
		}

		if(tg.getId() != null) 
		{
			tg=(TriageGroup)this.reattach(tg);
			if(StringUtils.isBlank(this.getParameter("delete")))
			{
				reattach(tg.getClinicians());
			}
			reattach(tg.getRelations());
		}
		if(!validTriageGroup()){
			return false;
		}
		
		
				// Remove pending deletions
				for(TriageRelation tr : getRelationsPendingDelete()) {
					for(TriageRelation existing : getTriageGroup().getRelations()) {
						if (matches(tr, existing) ) {
							existing.setActive(false);
						}
					}
				}
				// Add pending adds
				for(TriageRelation tr : getRelationsPendingAdd()) {
					boolean added = false;
					for(TriageRelation existing : getTriageGroup().getRelations()) {
						if (matches(tr, existing) ) {
							existing.setActive(true);
							existing.setName(tr.getName());
							added = true;
							break;
						}
					}
					if ( ! added ) {
						tr.setActive(true);
						tg.addRelation(tr);
					}
		
				}
				clearPendingRelations();
			if(log.isInfoEnabled()){
				log.info("107--->Before AdminService SaveTriage Group --->"+tg);
			}
			ServiceResponse<TriageGroup> response  = getAdminService().saveTriageGroup(tg);
			
			if(log.isInfoEnabled()){
				log.info("108--->After AdminService SaveTriage Group --->"+response.getPayload());
			}
			
			if ( response.getMessages().hasErrorMessages() )
			{
				addActionError("Error saving triage group");
				if(log.isErrorEnabled()){
					log.info("109--->Error occured while saving triage group--->"+response.getPayload()+"^"+response.getMessages());
				}
				return false;
			} else
			{
				TriageGroup saved = response.getPayload();
				if(StringUtils.isBlank(this.getParameter("delete")))
				{
					setTriageGroup(saved);
					setNeedReload(true, saved.getName());
				}
				return true;
			}
	}

	protected Map<Long, Clinician> getAllCliniciansMap() {
		Map<Long, Clinician> result = new HashMap<Long, Clinician>();
		Collection<Clinician> clinicians = getUserManagementService()
			.getCliniciansForStation(getFacility().getStationNumber()).getCollection();
		for(Clinician c : clinicians) {
			result.put(c.getId(), c);
		}
		return result;
	}

	public Collection<TriageRelation> getPrimaryProviderRelations() {
		Collection<TriageRelation> relations = getRelations(RelationTypeEnum.PRIMARY_PROVIDER);
		storeSelectedTriageRealationship(relations);
		return relations;
	}

	public Collection<TriageRelation> getClinicRelations() {
		Collection<TriageRelation> relations = getRelations(RelationTypeEnum.CLINIC);
		storeSelectedTriageRealationship(relations);
		return relations;
	}

	public Collection<TriageRelation> getTeamRelations() {
		Collection<TriageRelation> relations = getRelations(RelationTypeEnum.TEAM);
		storeSelectedTriageRealationship(relations);
		return relations;
	}

	public Collection<TriageRelation> getPatientRelations() {
		Collection<TriageRelation> relations = getRelations(RelationTypeEnum.PATIENT);
		storeSelectedTriageRealationship(relations);
		return relations;
	}

	public List<String> getBlockedTGPatientsList() {
		List<String> blockedTGPatientsList = new ArrayList<String>();
		List<Object[]> patientsList = getPatientBlockedService().getBlockedPatientsDetailsByTriageGroupId(getTriageGroup().getId());
		for(Object[] obj:patientsList){
			String patientName = obj[1].toString()+", "+obj[2].toString()+(!obj[3].equals(" ")?" "+obj[3].toString():"")+"(SSN:"+(obj[4]!=null?obj[4].toString():"")+")(DOB: "+obj[5].toString()+")";			
			blockedTGPatientsList.add(patientName);
		}
		return blockedTGPatientsList;
	}

	public List<String> getBlockedFacilityPatientsList() {
		List<String> blockedFacilityPatientsList = new ArrayList<String>();
		List<Object[]> patientsList = getPatientBlockedService().getBlockedFacilityPatientsDetailsByStation(Long.parseLong(getFacility().getStationNumber()));
		for(Object[] obj:patientsList){
			String patientName = obj[1].toString()+", "+obj[2].toString()+(!obj[3].equals(" ")?" "+obj[3].toString():"")+"(SSN:"+(obj[4]!=null?obj[4].toString():"")+")(DOB: "+obj[5].toString()+")";
			blockedFacilityPatientsList.add(patientName);
		}
		return blockedFacilityPatientsList;
	}

	private void storeSelectedTriageRealationship(Collection<TriageRelation> store){
		Map<String, String> selectedTriageRealationship = new HashMap<String, String>();
		for (Iterator iter = store.iterator(); iter.hasNext();) {
			TriageRelation element = (TriageRelation) iter.next();
			selectedTriageRealationship.put(element.getVistaIen(),element.getName());

		}
		setSessionAttribute("selectedTriageRelationship",selectedTriageRealationship);

	}
	/*
	 *  TRIAGERELATION_COMPARATOR implmented for the CR#4609. (Sort Selected Clinics, Selected Providers, Selected OE/RR Teams).
	 *  Comparator used to sort object TriageRelation based on the name.
	 *
	 */
	public static final Comparator<TriageRelation> TRIAGERELATION_COMPARATOR = new Comparator<TriageRelation>() {
		public int compare(TriageRelation triageRelationObj1, TriageRelation triageRelationObj2) {
			if(triageRelationObj1 == null || triageRelationObj2 == null) return 0;
			int result = triageRelationObj1.getName().toUpperCase().compareTo(triageRelationObj2.getName().toUpperCase());
			return result;
		}
	};

	public static final Comparator<Object> LIST_STRING_COMPARATOR = new Comparator<Object>()
	{
		public int compare ( Object o1, Object o2 )   {
		     String s1 =  ( String ) o1;
		     String s2 =  ( String ) o2;
		     return s1.toUpperCase() .compareTo (s2.toUpperCase()) ;
		    }
		   public boolean equals ( Object o )   {
		     String s =  ( String ) o;
		     return compare ( this, o ) ==0;
		    }
	};

	private Collection<TriageRelation> getRelations(RelationTypeEnum type) {
		Collection<TriageRelation> result = new HashSet<TriageRelation>();


		for(TriageRelation tr : getTriageGroup().getRelations()) {
			if ( tr.getRelationType() == type && tr.isActive() ) {
				result.add(tr);
			}
		}
		// Removed pending deletions
		for(TriageRelation tr : getRelationsPendingDelete()) {
			Collection<TriageRelation> removeFromResult = new HashSet<TriageRelation>();
			for(TriageRelation resultTr : result) {
				if (matches(tr, resultTr) ) {
					removeFromResult.add(resultTr);
				}
			}
			result.removeAll(removeFromResult);
		}
		// Add pending adds
		for(TriageRelation tr : getRelationsPendingAdd() ) {
			if (type.equals(tr.getRelationType())) {
				result.add(tr);
			}
		}
		Locale.setDefault(Locale.ENGLISH);
	 	TreeSet sortTriageRelationSet = new TreeSet(TRIAGERELATION_COMPARATOR);	// Implemented for CR#4609. (Sort Selected Clinics, Selected Providers, Selected OE/RR Teams).
	 	sortTriageRelationSet.addAll(result);
		return sortTriageRelationSet;
	}

	public UserManagementService getUserManagementService() {
		return userManagementService;
	}

	public void setUserManagementService(UserManagementService userManagementService) {
		this.userManagementService = userManagementService;
	}

	public TriageGroupService getTriageGroupService() {
		return triageGroupService;
	}

	public void setTriageGroupService(TriageGroupService triageGroupService) {
		this.triageGroupService = triageGroupService;
	}

	protected boolean validTriageGroupName(String name) {
		if ( StringUtils.isBlank(name) || name.equalsIgnoreCase("Enter Triage Group Name")) {
						// name.equalsIgnoreCase("Enter Triage Group Name)... implemented for CR#4803
			this.addActionError("Triage group name must be supplied");
			return false;
		}
		TriageGroup existing = getTriageGroupService().findTriageGroupByName(name).getPayload();
		if ( existing != null ) {
			if(!existing.isActive())
			{
				this.addActionError("This triage group name is currently inactive, to reactivate this triage group \"" + name +  "\" please contact MHV helpdesk,  if you do not want to reactivate this triage group then you must choose another name.");
				return false;
			}
			if ( getTriageGroup().getId() == null ) {
				this.addActionError("This triage group name is already in use.");
				return false;
			} else if ( ! existing.getId().equals(getTriageGroup().getId())) {
				this.addActionError("The triage group name \"" + name + "\" is already in use.");
				return false;
			}
		}
		return true;
	}

	private void manageTriageRelationPendingAdd(TriageRelation tr) {
		Collection<TriageRelation> toDelete = getRelationsPendingDelete();
		Collection<TriageRelation> toAdd = getRelationsPendingAdd();
		manageTriageRelationChange(toAdd, toDelete, tr);
	}

	private void manageTriageRelationPendingDelete(TriageRelation tr) {
		Collection<TriageRelation> toDelete = getRelationsPendingDelete();
		Collection<TriageRelation> toAdd = getRelationsPendingAdd();
		manageTriageRelationChange(toDelete, toAdd, tr);
	}

	private void manageTriageRelationChange(Collection<TriageRelation> toAddColl, Collection<TriageRelation> toDeleteColl, TriageRelation tr) {
		// See if we can just pull it from the to delete collection
		TriageRelation removeMe = null;
		for(TriageRelation toDelete : toDeleteColl) {
			if ( matches(toDelete, tr) ) {
				removeMe = toDelete;
				break;
			}
		}
		if ( removeMe != null ) {
			toDeleteColl.remove(removeMe);
			return;
		}
		for(TriageRelation added : toAddColl) {
			if ( matches(added, tr) ) {
				// Nothing to do
				added.setName(tr.getName());
				return;
			}
		}
		toAddColl.add(tr);
	}

	private boolean matches(TriageRelation tr1, TriageRelation tr2) {
		return tr1.getVistaIen().equals(tr2.getVistaIen())
			&& tr1.getRelationType().equals(tr2.getRelationType())
			&& tr1.getStationNumber().equals(tr2.getStationNumber());
	}

	@SuppressWarnings("unchecked")
	private Collection<TriageRelation> getRelationsPendingAdd() {
		Collection<TriageRelation> result = (Collection)getSessionAttribute("triageRelationsPendingAdd");
		if ( result == null ) {
			result = new ArrayList<TriageRelation>();
			setSessionAttribute("triageRelationsPendingAdd", result);
		}
		return result;
	}



	@SuppressWarnings("unchecked")
	private Collection<TriageRelation> getRelationsPendingDelete() {
		Collection<TriageRelation> result = (Collection)getSessionAttribute("triageRelationsPendingDelete");
		if ( result == null ) {
			result = new ArrayList<TriageRelation>();
			setSessionAttribute("triageRelationsPendingDelete", result);
		}
		return result;
	}

	private void clearPendingRelations() {
		getRelationsPendingAdd().clear();
		getRelationsPendingDelete().clear();
	}

	private void clearMembersAndRelations() {
		TriageGroup tg = getTriageGroup();
		if ( tg != null ) {
			tg.getClinicians().clear();
			clearPendingRelations();
			for(TriageRelation tr : tg.getRelations()) {
				manageTriageRelationPendingDelete(tr);
			}
		}
	}

	protected boolean cancelButtonPressed() {
		return ! StringUtils.isBlank(getParameter("[CANCEL BUTTON]"));
	}

	/*
	 * sortedResultMap Implemented for CR#4609. Sort Clinics, Providers, OE/RR Teams.
	 * This method sort the hashmap based on values and return the sorted hashmap.
	 */
	private TreeMap sortedResultMap(Map<String,String> resultMap)
	{
		TreeMap sortedResultMap = new TreeMap(LIST_STRING_COMPARATOR);
		List mapKeys = new ArrayList(resultMap.keySet());
		List mapValues = new ArrayList(resultMap.values());
		resultMap.clear();
		TreeSet sortedSet = new TreeSet(mapValues);
		Object[] sortedArray = sortedSet.toArray();
		for (int i=0; i<sortedArray.length; i++){
			sortedResultMap.put((String)mapKeys.get(mapValues.indexOf(sortedArray[i])), (String)sortedArray[i]);
 		}

		return sortedResultMap;
	}

	public UserDao getUserDao() {
		return userDao;
	}

	public void setUserDao(UserDao userDao) {
		this.userDao = userDao;
	}

	public RelationshipManagementService getRelationshipManagementService() {
		return relationshipManagementService;
	}

	public void setRelationshipManagementService(
			RelationshipManagementService relationshipManagementService) {
		this.relationshipManagementService = relationshipManagementService;
	}

	public PatientBlockedService getPatientBlockedService() {
		return patientBlockedService;
	}

	public void setPatientBlockedService(PatientBlockedService patientBlockedService) {
		this.patientBlockedService = patientBlockedService;
	}


}
